CREATE TABLE meta_data ( 
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    tenant_id INTEGER,
    meta_key TEXT,
    meta_value TEXT,
    is_active BOOLEAN DEFAULT 1,
    is_deleted BOOLEAN DEFAULT 0,
    created_at TEXT DEFAULT (DATETIME('now')),
    updated_at TEXT DEFAULT (DATETIME('now'))
);

CREATE TABLE meta_data_history (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    tenant_id INTEGER NOT NULL,
    meta_data_id INTEGER NOT NULL,
    change_type TEXT NOT NULL,
    change_data TEXT NOT NULL,
    table_of_source TEXT NOT NULL, -- Name of the table where the change occurred
    changed_by INT NOT NULL, -- User ID of the person who made the change
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)
