<?php
    function checkIfDeleted($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT id FROM $table WHERE id = :id and is_deleted = 1");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($data) {
                        return ['status' => 'failed', 'message' => 'Record already deleted'];
            } else {
                return ['status' => 'success'];
            }
    }
    function getDataForHistory($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT * FROM $table WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        // convert result to json with column names as keys
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        json_encode($data);
        if ($data) {
            return ['status' => 'success', 'historyData' => $data];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function checkDuplicateRecord($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table = $inputData['table'] ?? null;
        $table = toSnakeCase($table);
        $dataKey = extractDataKeyFromTableName($inputData['table']);
        $data = $inputData[$dataKey] ?? [];

        if (!$table) {
            return ['status' => 'failed', 'message' => 'Table not specified'];
        }

        $map = menuTableColumnMapping($table, $inputData['roleId'] ?? 0, "view");
        $columnMap = $map['filtered'] ?? null;

        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'Invalid table or insufficient permissions'];
        }

        // Define which fields make the record unique (you may want to pass this in $inputData)
        $uniqueFields = $inputData['uniqueFields'];
        $whereClauses = [];
        $params = [];

        foreach ($uniqueFields as $fieldKey) {
            $meta = $columnMap[$fieldKey] ?? null;
            $dbField = $meta['mapping'] ?? null;

            if (!$dbField || !isset($data[$fieldKey])) {
                return ['status' => 'failed', 'message' => "$fieldKey is required"];
            }

            $whereClauses[] = "$dbField = :$fieldKey";
            $params[$fieldKey] = $data[$fieldKey];
        }

        // Add soft delete clause
        $whereClauses[] = "is_deleted = 0";

        $whereSql = implode(' AND ', $whereClauses);
        $sql = "SELECT id FROM $table WHERE $whereSql";
        $stmt = $pdo->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue(":$key", $value);
        }
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            return ['status' => 'failed', 'message' => 'Record already exists'];
        }

        return ['status' => 'success'];
    } 
    function setTenantId($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $host = $_SERVER['HTTP_HOST'] ?? '';
        $host = strtolower($host);
        $parts = explode('.', $host);
        $cleanParts = array_filter($parts, fn($part) => $part !== 'admin');
        $cleanHost = implode('.', $cleanParts);
        $cleanUrl = 'https://' . $cleanHost;
        // strip www. if it exists
        $cleanUrl = preg_replace('/^https?:\/\/(www\.)?/', 'https://', $cleanUrl);

        // Build SQL
        $sql = "SELECT id FROM tenant WHERE domain = :http and is_deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':http', $cleanUrl);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $_SESSION['tenantId']       = $data['id'];
            return ['status' => 'success', 'message' => 'Tenant ID found'];
        } else {
            return ['status' => 'failed', 'message' => 'Tenant ID not found'];
        }
    }
    function viewMetaData($inputData) {
        // Implementation for viewing meta data
        $db = $inputData['db']['dbApp'];
        $viewType = $inputData['viewType'] ?? 'restrictive';

        $tenantId = $inputData['tenantId'] ?? null;

        if (!$tenantId) {
            return ['status' => 'failed', 'message' => 'Tenant ID not specified'];
        }

        if ($viewType === 'superAdmin') {
            $sql = "SELECT * FROM meta_data WHERE tenant_id = :tenantId AND is_deleted = 0";
        } else {
            $sql = "SELECT * FROM meta_data WHERE tenant_id = :tenantId AND is_deleted = 0 and is_active = 1";
        }
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':tenantId', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return ['status' => 'success', 'data' => $data];

    }

?>
