# Menu API Interface Specification

---

## Overview

This document outlines the API contract for managing menu configurations in the system. It includes endpoints for creating, updating, deleting, viewing, and duplicating menu entries (`menu_menus`). All requests are processed through a single PHP entry point (`function.php`) using `POST` requests, with operations determined by the `action` field in the payload.

---

## API Summary Table


| Action| Method| Auth Required | Payload Object| Description|
|-|-|-|-|-|
| [`insertMetaData`](#insertMetaData)                   | POST| Yes | `metaData` | Insert a new meta data value |
| [`viewMetaDataSuperAdmin`](#viewMetaDataSuperAdmin)   | GET | Yes |            | View all meta data values for a tenant |
| [`viewMetaDataPublic`](#viewMetaDataPublic)           | GET | No  |            | View meta data values where active and not delted |
| [`updateMetaData`](#updateMetaData)                   | POST| Yes | `metaData` | Update a meta data values (not working)|


## Payload Structures

### <a id="insertMetaData"></a>`insertMetaData`
```json
{
  "action": "insertMetaData",
  "metaData": [
    "metaKey"   :"test_key",
    "metaValue" : "test_value",
    "isActive"  : "1" // optional 
  ]
}
```

### <a id="viewMetaDataSuperAdmin"></a>`viewMetaDataSuperAdmin`
```json
{
  "action": "viewMetaDataSuperAdmin"
}
```

### <a id="viewMetaDataPublic"></a>`viewMetaDataPublic`
```json
{
  "action": "viewMetaDataPublic"
}
```

### <a id="updateMetaData"></a>`updateMetaData`
```json
{
  "action": "updateMetaData",
  "metaData": [
    "id" : "int",
    "metaKey"   : "test_key",
    "metaValue" : "test_value",
    "isActive"  : "[1|0]" // optional 
    "isDelete"  : "[1|0]" // optional
  ]
}
```