<?php
// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    require_once __DIR__ . '\..\..\core\src\Fcors.php';
    require_once __DIR__ . '\..\..\core\unit-test\scripts\bootstrap.php';
    require_once __DIR__ . '\..\..\core\src\generic.php';
    $testInfo['0'] = ("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . "./../error_monitor.php";
    require_once __DIR__ . "./../generic.php";
}

require_once __DIR__ . "/core.php";
require_once __DIR__ . "/insert.php";

$inputData = initializeGeneric();  // ✅ Ensures fresh initialization in each test

// include_once("hub-spot.php");
$inputData['requiresAdmin'] = [''];
$inputData['keepLive'] = checkLive();

if(!isset($inputData['action']) || empty($inputData['action'])){
    $out['status']   = 'failed';
    $out['message']  = 'No Action Found';
    echo json_encode(propagateStatusAndMessage($out));
exit;
}

$action = $inputData['action'];


// check if action need auth and if does check it valid otherwise move to swithc statments 
$security = SecurityCheck($inputData);

if($security['security'] === '1'){
    switch ($action) {
        case "emailRequest":
            $out = saveEmailRequest($inputData);
            $out = sendRequestEmail($inputData);
            // hubSpotSend($inputData);
            break;
        default:
            $out['result']['status']   = 'failed';
            $out['result']['message']  = 'No Action Found';
            break;
    }
} else {
    $out['result']['status']   = 'failed';
    $out['result']['message']  = 'Security Check Failed';
}



echo json_encode(propagateStatusAndMessage($out));
?>
