<?php
     function saveEmailRequest($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];

        
        // Services
        $services2 = $inputData['services']; // Services data as a string
        $services3 = explode(',', $services2); // Split into array by commas
        $services = "";
        foreach ($services3 as $service4) {
            // Decode HTML entities and trim surrounding quotes and brackets
            $ser = trim(html_entity_decode($service4), '"');
            $ser2 = str_replace(["[", "]"], "", $ser); // Remove square brackets
            // Append each cleaned service to the final services string
            $services .= $ser2 . ", "; 
        }
        // Trim the final trailing comma and remove any extra quotes
        $services = rtrim($services, ", ");
        $services = str_replace('"', "", $services);

        $image_info = json_decode(stripslashes(html_entity_decode($inputData['imgList'])));
        $img_info = "";
        $i = 0;
        if (is_array($image_info)) {
            foreach ($image_info as $file) {
            if($i == 0){
                $i++;
            }else{
                $img_info = $img_info . "-|-";
            }
            // Access the URL
                $img_info = $img_info . $file->url ;
            }
        }

        $stmt = $db->prepare("insert into email_request (name, email, phone, enquiry, image_info, location, timescale, services) values(:name, :email, :phone, :enquiry, :image_info, :location, :timescale, :services)");
        $stmt->bindParam(':name', $inputData['name']);
        $stmt->bindParam(':email', $inputData['email']);
        $stmt->bindParam(':phone', $inputData['phone']);
        $stmt->bindParam(':enquiry', $inputData['enquiry']);
        $stmt->bindParam(':image_info', $img_info);
        $stmt->bindParam(':location', $inputData['location']);
        $stmt->bindParam(':timescale', $inputData['timescale']);
        $stmt->bindParam(':services', $services);
        $stmt->execute();
        $userid = $db->lastInsertId();
        if ($stmt->rowCount() > 0){
            $result['db']['status'] = 'success';
            return $result;
        }else{
            $result['db']['status'] = 'failed';
            return $result;
        }  
    }
?>