<?php

    function newBrand($inputData){
        $data = CheckBrandisNew($inputData);
        if($data['status'] == 'Success'){
            $data = createBrand($inputData);
        }
        return $data;
    }

    function viewProductInfoFromBrand($inputData){
        $brandId = $inputData['brandId'];
        $data = [];
        if($brandId == '10'){
            $data = edgeBanding($inputData);
        }else{ 
           $data = standardProduct($inputData);
        }
        return $data;  
    }


    function executeDatabaseOperation( $inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();

            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'Failed', 'error' => "Duplicate entry detected: " . $errorMessage];
            }else{
                $results = ['status' => 'Failed', 'error' => "Unknown failure"];
            }
        }
        return $results;
    }

    function contentChange($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->beginTransaction();
        try{
            $data = getProductForHistory($inputData);
            $inputData['getOldContent'] = $data['cms'];
            $inputData['change_type']   = $inputData['type'];
            $check = insertChangeRecord($inputData);
            if($check['status'] == 'Success'){
                $inputData['nextOperation'] = $inputData['followUp'];
                $result['result'] = executeDatabaseOperation($inputData);
            }else{
                $result[] = $check;
            }
            $pdo->commit();
        }catch (Exception $e) {
        // Rollback transaction on error
            $pdo->rollback();
            $result['error'] =  $e;
        }
        return $result;
    }
?>