
DELIMITER $$

CREATE TRIGGER trg_only_one_active_theme
BEFORE INSERT ON tenant_theme
FOR EACH ROW
BEGIN
    IF NEW.theme_status   = 'active' THEN
        UPDATE tenant_theme
        SET theme_status  = 'draft'
        WHERE tenant_id = NEW.tenant_id
          AND theme_status  = 'active';
    END IF;
END$$

DELIMITER ;


DELIMITER $$

CREATE TRIGGER trg_only_one_active_theme_update
BEFORE UPDATE ON tenant_theme
FOR EACH ROW
BEGIN
    IF NEW.theme_status  = 'active' AND OLD.theme_status  != 'active' THEN
        UPDATE tenant_theme
        SET theme_status  = 'draft'
        WHERE tenant_id = NEW.tenant_id
          AND id != NEW.id
          AND theme_status  = 'active';
    END IF;
END$$

DELIMITER ;
