<?php

    function idList(){
        $idList = ['tenant' => 'tenantId', 'tenantTheme' => 'themeId', 'tenantContact' => 'contactId', 'tenantBusinessHours' => 'businessHoursId'];
        return $idList;
    }
    function tableColumnMapping(){
        $tablesColumn = [
            'tenant' => [
                'companyName'           => ['mapping' => 'company_name',            'updateRole' => [1,3,4],    'optional' => 0],
                'domain'                => ['mapping' => 'domain',                  'updateRole' => [1,3],      'optional' => 0],
                'companyNumber'         => ['mapping' => 'company_number',          'updateRole' => [1,3,4],    'optional' => 0],
                'foodHygieneId'         => ['mapping' => 'food_hygiene_id',         'updateRole' => [1,3],      'optional' => 0],
                'primaryContactName'    => ['mapping' => 'primary_contact_name',    'updateRole' => [1,3],      'optional' => 0],
                'tenantStatus'          => ['mapping' => 'tenant_status',           'updateRole' => [1,3],      'optional' => 0],
                'isDeleted'             => ['mapping' => 'is_deleted',              'updateRole' => [1],        'optional' => 0],
                'parentId'              => ['mapping' => 'parent_id',               'updateRole' => [1,3],      'optional' => 0],
            ],
            'tenantTheme' => [
                'themeName'             => ['mapping' => 'theme_name',              'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'primaryColor'          => ['mapping' => 'primary_color',           'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'secondaryColor'        => ['mapping' => 'secondary_color',         'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'textColor'             => ['mapping' => 'text_color',              'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'secondaryTextColor'    => ['mapping' => 'secondary_text_color',    'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'accentColor'           => ['mapping' => 'accent_color',            'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'backgroundColor'       => ['mapping' => 'background_color',        'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'buttonColor'           => ['mapping' => 'button_color',            'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'themeStatus'           => ['mapping' => 'theme_status',            'updateRole' => [1,2,3,4,5],  'optional' => 1],
                'isApplied'             => ['mapping' => 'is_applied',              'updateRole' => [1,2,3,4,5],  'optional' => 1],
                'isDeleted'             => ['mapping' => 'is_deleted',              'updateRole' => [1,2,3,4],    'optional' => 1],
            ],
            'tenantContact' => [
                'contactType'           => ['mapping' => 'contact_type',            'updateRole' => [1,2,3,4,5],      'optional' => 0],
                'isPrimary'             => ['mapping' => 'is_primary',              'updateRole' => [1,2,3,4,5],      'optional' => 0],
                'label'                 => ['mapping' => 'label',                   'updateRole' => [1,2,3,4,5],      'optional' => 0],
                'contactValue'          => ['mapping' => 'contact_value',           'updateRole' => [1,2,3,4,5],      'optional' => 0],
                'userId'                => ['mapping' => 'user_id',                 'updateRole' => [1,2,3],          'optional' => 1],
                'isDeleted'             => ['mapping' => 'is_deleted',              'updateRole' => [1,2,3,4,5],      'optional' => 1],
            ],
            'tenantBusinessHours' => [
                'hoursCategory'         => ['mapping' => 'hours_category',          'updateRole' => [1,2,3,4,5],      'optional' => 0],
                'openingDay'            => ['mapping' => 'opening_day',             'updateRole' => [1,2,3,4,5],      'optional' => 1],
                'specificDate'          => ['mapping' => 'specific_date',           'updateRole' => [1,2,3,4,5],      'optional' => 1],
                'openTime'              => ['mapping' => 'open_time',               'updateRole' => [1,2,3,4,5],      'optional' => 1],
                'closeTime'             => ['mapping' => 'close_time',              'updateRole' => [1,2,3,4,5],      'optional' => 1],
                'isClosed'              => ['mapping' => 'is_closed',               'updateRole' => [1,2,3,4,5],      'optional' => 1],
                'isDeleted'             => ['mapping' => 'is_deleted',              'updateRole' => [1,2,3,4],        'optional' => 1],
            ]
        ];
        return $tablesColumn;
    }
    function updateContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        // 00 Check if tableid is present in the input data
        $tableName = $inputData['tableName'];
        $idName = $inputData['idName'];
        if(!isset($inputData[$tableName][$idName.'Id']) || empty($inputData[$tableName][$idName.'Id'])){
            if(!isset($inputData[$idName.'Id']) || empty($inputData[$idName.'Id'])){
                $result['status'] = 'failed';
                $result['message'] = 'Missing '.$idName.'Id';
                return $result;
            }
        }

        // 01 Check for the id field related to the table from the idList function
        $idList = idList();
        $tablesColumn = tableColumnMapping();
        if(array_key_exists($inputData['tableName'], $idList)){
            $inputData['id'] = $inputData[$inputData['tableName']][$idList[$inputData['tableName']]]?? $inputData[$idName.'Id'];
        }
        if(array_key_exists('parentId', $tablesColumn[$tableName])){
            $inputData['checkParent'] = 1;
        }else{
            $inputData['checkParent'] = 0;
        }

        // 02 Check if the id field is present in the input data
        if(!isset($inputData['id']) || empty($inputData['id'])){
            $result['status'] = 'failed';
            $result['message'] = 'Missing '.$inputData['idName'].'Id';
            $result['check'] = 2;
            return $result;
        }
        // 02.1 check if recored is soft deleted
        $inputData['nextOperation'] = 'checkIfAlreadyDeleted';
        $res = executeDatabaseOperation($inputData);
        if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
            $result['output'] = $res;
            $result['message'] = 'No content found for the id '.$inputData['id'];
            $result['status'] = 'failed';
            return $result;
        }


        //03 begin transaction
        $pdo->beginTransaction();
        try {

            // 04 Get history data for the id field related to the table from the idList function
            $inputData['nextOperation'] = 'selectDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
                $result['output'] = $res;
                $result['message'] = 'No content found for the id '.$inputData['id'];
                $result['status'] = 'failed';
                //04.b Rollback transaction
                $pdo->rollback();
                return $result;
            }
            // 04.a check history for children if the tenant is deleted
                // TO BUILD


            $inputData['his'] = $res['his'];
            // 05 insert history data into the history table
            $inputData['nextOperation'] = 'insertHistoryRecord';
            $res = executeDatabaseOperation($inputData);
 
            // 06 check if the action is delete and if so check if not already deleted
            if($inputData['actionType'] == 'delete'){
                $inputData['nextOperation'] = 'checkIfAlreadyDeleted';
                $res = executeDatabaseOperation($inputData);
                if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
                    //04.b Rollback transaction
                    $pdo->rollback();
                    return $res;
                }
            }

            // 07 make chanage that is requierd to be made to the table
            $inputData['nextOperation'] = 'genericUpdateStatment';
            $res = executeDatabaseOperation($inputData);
            if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
                //04.b Rollback transaction
                $pdo->rollback();
                return $res;
            }
            // 08 commit the transaction
            $pdo->commit();
        } catch (Exception $e) {
            // 09 Rollback transaction on error
            $pdo->rollback();
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // 10 Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModebug']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
            return $results;
        }

        return $out = [
            'status' => 'success'
        ];
    }
    function executeDatabaseOperation( $inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModebug']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }   
    function checkTenantExists($inputData){
        $tempHold = $inputData['nextOperation'];
        $inputData['nextOperation'] = 'checkIfTenantIdIsValid';
        $res = executeDatabaseOperation($inputData);
        if($res['status'] == 'failed'){
            return $res;
        }
        $inputData['nextOperation'] = $tempHold;
        $out = executeDatabaseOperation($inputData);
        return $out;
    }
    function tenantIdAdminCheck($inputData){
        if(isset($inputData['tenantId'])){
            return ['status' => 'success', 'message' => 'Tenant ID is present'];
        }
        if(isset($inputData['setTenantId'])){
            $_SESSION['tenantId'] = $inputData['setTenantId'];
            return ['status' => 'success', 'message' => 'Tenant ID is present'];
        }
       
        $inputData['nextOperation'] = 'setTenantId';
        $res = executeDatabaseOperation($inputData);
        
        return $res;
    }
    function insertNewTenantWithCheck($inputData){
        // check if the url exists in the database
        $inputData['nextOperation'] = 'viewTenatDomainCheck';
        $res = executeDatabaseOperation($inputData);
        if($res['status'] == 'found'){
            return ['status' => 'failed', 'message' => 'Duplicate Entry: Domain already exists'];
        }

        $inputData['nextOperation'] = 'insertNewTenant';
        $out = executeDatabaseOperation($inputData);
        if($out['status'] === 'success' && isset($inputData['tenant']['parentId'])){
            $inputData['tenant']['tenantId'] = $out['tenantId'];
            $inputData['nextOperation'] = 'addTenantToParent';
            $out = executeDatabaseOperation($inputData);
        }
        return $out;
    }
    function clearTenantId($inputData){
        if(isset($inputData['tenantId'])){
            unset($_SESSION['tenantId']);
            return ['status' => 'success', 'message' => 'Tenant ID is cleared'];
        }
        return ['status' => 'failed', 'message' => 'Tenant ID is not set'];
    }
?>