Drop trigger if exists trg_only_one_active_theme;

Drop trigger if exists trg_only_one_active_theme_update;

-- Trigger to ensure only one active theme per tenant

/* Depricated: This trigger is not needed anymore as the application logic handles this. 
   Keeping it here for reference. 
   The trigger ensures that only one theme can be active at a time for a tenant.
   If a new theme is set to active, all other themes for that tenant are set to draft.



DELIMITER $$

CREATE TRIGGER trg_only_one_active_theme
BEFORE INSERT ON tenant_theme
FOR EACH ROW
BEGIN
    IF NEW.theme_status   = 'active' THEN
        UPDATE tenant_theme
        SET theme_status  = 'draft',
        is_applied = 0
        WHERE tenant_id = NEW.tenant_id
          AND theme_status  = 'active';
    END IF;
END$$

DELIMITER ;


DELIMITER $$

CREATE TRIGGER trg_only_one_active_theme_update
BEFORE UPDATE ON tenant_theme
FOR EACH ROW
BEGIN
    IF NEW.theme_status  = 'active' AND OLD.theme_status  != 'active' THEN
        UPDATE tenant_theme
        SET theme_status  = 'draft',
        is_applied = 0
        WHERE tenant_id = NEW.tenant_id
          AND id != NEW.id
          AND theme_status  = 'active';
    END IF;
END$$

DELIMITER ;

*/