# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, 'SystemAdmin', 'Platform'),
(2, 'SupportAgent', 'Platform'),
(3, 'ContentModerator', 'Platform'),
(4, 'BusinessOwner', 'Tenant'),
(5, 'BusinessManager', 'Tenant'),
(6, 'Staff', 'Tenant'),
(7, 'Operator', 'Tenant'),
(8, 'Customer', 'Public');
```

## API Summary Table

| Action                          | Method | Required Role      | Payload Object           | Description                                                            |
|---------------------------------|--------|--------------------|--------------------------|------------------------------------------------------------------------|
| `newTenant`                     | POST   | 1                  | `tenant`                 | Create a new tenant                                                    |
| `updateTenant`                  | POST   | 1, 3               | `tenant`                 | Update an existing tenant                                              |
| `deleteTenant`                  | POST   | 1                  | `tenant`                 | Soft-delete a tenant                                                   |
| `viewTenantSysAdmin`            | GET    | 1, 2, 3            |                          | View tenant detail (sysadmin)                                          |
| `viewTenantOwner`               | GET    | 4                  |                          | View tenant detail (owner view)                                        |
| `viewTenantPublic`              | GET    |                    |                          | View tenant detail (public view)                                       |
| `addNewTenantTheme`             | POST   | 1, 2, 3, 4, 5      | `tenantTheme`            | Add a new theme to a tenant                                            |
| `updateTenantTheme`             | POST   | 1, 2, 3, 4, 5      | `tenantTheme`            | Update an existing theme                                               |
| `viewThemeSysAdmin`             | GET    | 1, 2, 3            |                          | View all themes (sysadmin view)                                        |
| `viewThemeOwner`                | GET    | 4, 5               | `themeId`                | View themes (owner view)                                               |
| `viewThemePublic`               | GET    | Any                | `themeId`                | View theme detail (public view)                                        |
| `insertNewTenantContactBusiness`| POST   | 1,2,3,4,5          | `tenantContact`          | Add a new tenant contact (Owner)                                       |
| `insertNewTenantContactOwner`   | POST   | 1, 2, 3            | `tenantContact`          | Add a new tenant contact (Admin)                                       |
| `viewTenantContactBusiness`     | GET    | 1, 2, 3            |                          | View contacts (SysAdmin)                                               |
| `viewTenantContactOwner`        | GET    | 4, 5               |                          | View contacts (Owner)                                                  |
| `viewTenantContactPublic`       | GET    | Any                |                          | View public contact records                                            |
| `updateTenantContact`           | POST   | 1, 2, 3, 4, 5      | `tenantContact`          | Update a tenant contact                                                |
| `deleteTenantContact`           | POST   | 1, 2, 3, 4, 5      | `tenantContact`          | Soft-delete a contact                                                  |
| `insertNewBusinessHours`        | POST   | 1, 2, 3, 4, 5      | `tenantBusinessHours`    | Insert or bulk insert business hours                                   |
| `viewBusinessHoursPublic`       | GET    | Any                |                          | Retrieve public business hours                                         |
| `viewBusinessHoursOwner`        | GET    | 4, 5, 6            |                          | View business hours (owner view)                                       |
| `viewBusinessHoursSysAdmin`     | GET    | 1                  |                          | View business hours (sysadmin view)                                    |
| `updateBusinessHours`           | POST   | 2, 4, 5            | `tenantBusinessHours`    | Update business hours                                                  |
| `deleteBusinessHours`           | POST   | 2, 4, 5            | `tenantBusinessHours`    | Soft-delete a business hour                                            |
| `viewTenantChangeHistory`       | GET    | 1, 2, 3            |                          | View full change history of a tenant                                   |
| `viewAllTenantsSuperAdmin`      | GET    | 1, 2, 3            |                          | View full view all tenants info high level                             |
| `setTenantId`                   | POST   |                    |                          | Sets the tenantId based of domain need to run on fist run              |
| `setTenantIdAdmin`              | POST   | 1, 2, 3            |                          | Sets the tenantId based of domain need to run on fist run for admin    |
| `clearTenantId`                 | POST   |  1, 2, 3           |                          | Clears the tenantId Super Admin Only                                   |

---

## Payload Structures

### `newTenant`
```json
{
  "action": "newTenant",
  "tenant": {
    "companyName": "string",
    "domain": "string",
    "companyNumber": "string",
    "foodHygieneId": "string",
    "primaryContactName": "string",
    "tenantStatus": "active|pending",
    "paymentProvider": "stripe|paypal|square|braintree" optional,
    "paymentApiKey": "String" optional,
    "parentId": optional
  }
}
```

### `updateTenant`
```json
{
  "action": "updateTenant",
  "tenant": {
    "companyName": optional,
    "domain": optional,
    "companyNumber": optional,
    "foodHygieneId": optional,
    "primaryContactName": optional,
    "tenantStatus": optional,
    "isDeleted": optional,
    "parentId": optional
  }
}
```

### `deleteTenant`
```json
{
  "action": "deleteTenant",
}
```

### `viewTenantSysAdmin`
```json
{
  "action": "viewTenantSysAdmin",
}
```

### `viewTenantOwner`
```json
{
  "action": "viewTenantOwner",
}
```

### `viewTenantPublic`
```json
{
  "action": "viewTenantPublic",
}
```

### `addNewTenantTheme`
```json
{
  "action": "addNewTenantTheme",
  "tenantTheme": {
    "themeName": "string",
    "primaryColor": "#000000",
    "secondaryColor": "#000000",
    "textColor": "#000000",
    "secondaryTextColor": "#000000",
    "accentColor": "#000000",
    "backgroundColor": "#000000",
    "buttonColor": "#000000"
  }
}
```

### `updateTenantTheme`
```json
{
  "action": "updateTenantTheme",
  "tenantTheme": {
    "themeId": int,
    "isApplied": "yes|no",
    "themeStatus": "active|draft|deleted",
    "isDeleted": optional
  }
}
```

### `viewThemeSysAdmin`
```json
{
  "action": "viewThemeSysAdmin",
}
```

### `viewThemeOwner`
```json
{
  "action": "viewThemeOwner",
}
```

### `viewThemePublic`
```json
{
  "action": "viewThemePublic",
  "themeId": int
}
```

### `insertNewTenantContactBusiness`
```json
{
  "action": "insertNewTenantContactBusiness",
  "tenantContact": {
    "label": "string",
    "contactType": "Email|Name|Phone|...",
    "contactValue": "string",
    "isPrimary": "yes|no"
  }
}
```

### `insertNewTenantContactOwner`
```json
{
  "action": "insertNewTenantContactOwner",
  "tenantContact": {
    "userId": int,
    "label": "string",
    "contactType": "string",
    "contactValue": "string",
    "isPrimary": "yes|no"
  }
}
```

### `viewTenantContactBusiness`
```json
{
  "action": "viewTenantContactBusiness",
}
```

### `viewTenantContactOwner`
```json
{
  "action": "viewTenantContactOwner",
}
```

### `viewTenantContactPublic`
```json
{
  "action": "viewTenantContactPublic",
}
```

### `updateTenantContact`
```json
{
  "action": "updateTenantContact",
  "tenantContact": {
    "contactId": int,
    "userId": optional,
    "label": "string",
    "contactType": "string",
    "contactValue": "string",
    "isPrimary": "yes|no"
  }
}
```

### `deleteTenantContact`
```json
{
  "action": "deleteTenantContact",
  "tenantContact": {
    "contactId": int,
    "userId": optional,
    "isDeleted": 1
  }
}
```

### `insertNewBusinessHours`
```json
{
  "action": "insertNewBusinessHours",
  "tenantBusinessHours": [
    {
      "hoursCategory": "store|delivery|special",
      "openingDay": "Monday|...",
      "openTime": "HH:MM:SS",
      "closeTime": "HH:MM:SS",
      "isClosed": optional,
      "specificDate": optional (for special)
    }
  ]
}
```

### `viewBusinessHoursPublic`
```json
{
  "action": "viewBusinessHoursPublic",
}
```

### `viewBusinessHoursOwner`
```json
{
  "action": "viewBusinessHoursOwner",
}
```

### `viewBusinessHoursSysAdmin`
```json
{
  "action": "viewBusinessHoursSysAdmin",
}
```

### `updateBusinessHours`
```json
{
  "action": "updateBusinessHours",
  "tenantBusinessHours": {
    "businessHoursId": int,
    "hoursCategory": "store|delivery|special",
    "openingDay": optional,
    "specificDate": optional,
    "openTime": optional,
    "closeTime": optional,
    "isClosed": optional,
    "isDeleted": optional
  }
}
```

### `deleteBusinessHours`
```json
{
  "action": "deleteBusinessHours",
  "tenantBusinessHours": {
    "businessHoursId": int,
    "isDeleted": 1
  }
}
```

### `viewTenantChangeHistory`
```json
{
  "action": "viewTenantChangeHistory",
}
```
### `viewAllTenantsSuperAdmin`
```json
{
  "action": "viewAllTenantsSuperAdmin"
}
```

### `setTenantIdAdmin`
```json
{
  "action": "setTenantIdAdmin"
  "setTenantId" : int optional (Needed if admin to set domain)
}
```

### `setTenantId`
```json
{
  "action": "setTenantId"
}
```

### `clearTenantId`
```json
{
  "action": "clearTenantId"
}
```
---

## Response Format

### Success
```json
{
  "status": "success",
  "message": "string",
  // additional data if applicable
}
```

### Failure
```json
{
  "status": "failed",
  "message": "Error message string"
}
```

---

## Frontend Implementation Notes

- Ensure session authentication is maintained
- Validate required fields before submission
- Show proper error/success messaging
- Use roleValue to determine UI behavior (edit/delete/submit availability)
- Display conditional components based on `isDeleted`, `isPrimary`, and `themeStatus`

---

_End of Document_

