<?php
// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    require_once __DIR__ . '\..\..\core\src\Fcors.php';
    require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
    require_once __DIR__ . '\..\..\core\src\generic.php';
    $testInfo['0'] = ("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . "./../generic.php";
}

require_once __DIR__ . "/core.php";
require_once __DIR__ . "/view.php";
require_once __DIR__ . "/insert.php";
require_once __DIR__ . "/update.php";

$inputData = initializeGeneric();

$inputData['requiresAdmin'] = [ 
        'newTenant'                     => [1],             'viewTenantOwner'                   => [4],         'viewTenantSysAdmin'        => [1,2,3], 
        'updateTenant'                  => [1,3],           'deleteTenant'                      => [1],         'addNewTenantTheme'         => [1,2,3,4,5], 
        'updateTenantTheme'             => [1,2,3,4,5],     'viewThemeOwner'                    => [4,5],       'viewThemeSysAdmin'         => [1,2,3],
        'insertNewTenantContactOwner'   => [1,2,3],         'insertNewTenantContactBusiness'    => [2,3,4,5],   'viewTenantContactOwner'    => [1,2,3,4,5],
        'viewTenantContactBusiness'     => [1,2,3],         'updateTenantContact'               => [1,2,3,4,5],
        'deleteTenantContact'           => [1,2,3,4,5],     'insertNewBusinessHours'            => [1,2,3,4,5], 'viewBusinessHoursOwner'    => [4,5,6],
        'updateBusinessHours'           => [2,4,5],         'deleteBusinessHours'               => [2,4,5],     'viewTenantChangeHistory'   => [1,2,3],
        'viewAllTenantsSuperAdmin'      => [1,2,3],         'setTenantIdAdmin'                  => [1,2,3],     'clearTenantId'             => [1,2,3],
        'addNewTenantDeliveryRules'     => [1,2,3,4,5],     'updateTenantDeliveryRules'         => [1,2,3,4,5], 'deleteTenantDeliveryRules' => [1,2,3,4,5], 
        'viewTenantDeliveryRulesOwner'  => [4,5],           'viewTenantDeliveryRulesSysAdmin'   => [1,2,3],     'insertTenantFees'          => [1,2,3],
        'updateTenantFees'              => [1,2,3],         'deleteTenantFees'                  => [1,2,3]
];
$inputData['keepLive'] = checkLive();
$action = $inputData['action'];

// check if action need auth and if does check it valid otherwise move to swithc statments 
$security = SecurityCheck($inputData); // skip security for a bit 

if(isset($inputData['tenantId']) == false || $inputData['tenantId'] == null ){
    setTenantId($inputData);
    reinitializeTenantId($inputData);
}

if($action == 'insertNewTenantContact'){
    $action = 'insertNewTenantContactBusiness';
}
if($action == 'viewTenantContactSysAdmin'){
    $action = 'viewTenantContactBusiness';
}
if($action == 'insertNewTenantContactAdmin'){
    $action = 'insertNewTenantContactOwner';
}

if($security['security'] === '1'){
    switch ($action) {
        case "test":
            $out['status']   = 'success';
            $out['message']  = 'Test Passed';
            break;
        case "newTenant":
            $out = insertNewTenantWithCheck($inputData);
            break;
        case "viewTenantPublic":
            $inputData['view'] = 'restricted';
            $inputData['nextOperation'] = 'selectTenantInfo';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantOwner":
            $inputData['view'] = 'owner';
            $inputData['nextOperation'] = 'selectTenantInfo';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantSysAdmin":
            $inputData['view'] = 'sysAdmin';
            $inputData['nextOperation'] = 'selectTenantInfo';
            $out = executeDatabaseOperation($inputData);
            break;
        case "updateTenant":
            $inputData['tableName'] = 'tenant';
            $inputData['idName'] = 'tenant';
            $inputData['actionType'] = 'update';
            $out = updateContent($inputData);
            break;
        case "deleteTenant":
            $inputData['tableName'] = 'tenant';
            $inputData['idName'] = 'tenant';
            $inputData['actionType'] = 'delete';
            $inputData['tenant']['tenantStatus'] = 'deleted';
            $inputData['tenant']['isDeleted'] = 1;
            $out = updateContent($inputData);
            break;
        case "addNewTenantTheme":
            $inputData['nextOperation'] = 'insertNewTenantTheme';
            $out = checkTenantExists($inputData);
            break;
        case "updateTenantTheme":
            $inputData['tableName'] = 'tenantTheme';
            $inputData['idName'] = 'theme';
            $inputData['actionType'] = 'update';
            $out = updateContent($inputData);
            break;
        case "viewThemePublic":
            $inputData['view'] = 'restricted';
            $inputData['nextOperation'] = 'viewThemes';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewThemeOwner":
            $inputData['view'] = 'owner';
            $inputData['nextOperation'] = 'viewThemes';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewThemeSysAdmin":
            $inputData['view'] = 'sysAdmin';
            $inputData['nextOperation'] = 'viewThemes';
            $out = executeDatabaseOperation($inputData);
            break;
        case "insertNewTenantContactOwner":
            $inputData['nextOperation'] = 'insertNewTenantContactAdmin';
            $out = checkTenantExists($inputData);
            break;
        case "insertNewTenantContactBusiness":
            $inputData['nextOperation'] = 'insertNewTenantContact';
            $out = checkTenantExists($inputData);
            break;
        case "viewTenantContactPublic":
            $inputData['view'] = 'restricted';
            $inputData['nextOperation'] = 'viewContact';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantContactOwner":
            $inputData['view'] = 'owner';
            $inputData['nextOperation'] = 'viewContact';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantContactBusiness":
            $inputData['view'] = 'sysAdmin';
            $inputData['nextOperation'] = 'viewContact';
            $out = executeDatabaseOperation($inputData);
            break;
        case "updateTenantContact":
            $inputData['tableName'] = 'tenantContact';
            $inputData['idName'] = 'contact';
            $inputData['actionType'] = 'update';
            $out = updateContent($inputData);
            break;
        case "deleteTenantContact":
            $inputData['tableName'] = 'tenantContact';
            $inputData['idName'] = 'contact';
            $inputData['actionType'] = 'delete';
            $out = updateContent($inputData);
            break;
        case "insertNewBusinessHours":
            $inputData['nextOperation'] = 'insertNewBusinessHours';
            $out = checkTenantExists($inputData);
            break;
        case "viewBusinessHoursPublic":
            $inputData['view'] = 'restricted';
            $inputData['nextOperation'] = 'viewBusinessHours';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewBusinessHoursOwner":
            $inputData['view'] = 'owner';
            $inputData['nextOperation'] = 'viewBusinessHours';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewBusinessHoursSysAdmin":
            $inputData['view'] = 'sysAdmin';
            $inputData['nextOperation'] = 'viewBusinessHours';
            $out = executeDatabaseOperation($inputData);
            break;
        case "updateBusinessHours":
            $inputData['tableName'] = 'tenantBusinessHours';
            $inputData['idName'] = 'businessHours';
            $inputData['actionType'] = 'update';
            $out = updateContent($inputData);
            break;
        case "deleteBusinessHours":
            $inputData['tableName'] = 'tenantBusinessHours';
            $inputData['idName'] = 'businessHours';
            $inputData['actionType'] = 'delete';
            $out = updateContent($inputData);
            break;
        case "viewTenantChangeHistory":
            $inputData['nextOperation'] = 'viewHistory';
            $out = checkTenantExists($inputData);
            break;
        case "viewAllTenantsSuperAdmin":
            $inputData['view'] = 'superAdmin';
            $inputData['nextOperation'] = 'selectTenantInfo';
            $out = executeDatabaseOperation($inputData);
            break;
        case "setTenantId":
            $out = setTenantId($inputData);
            break;
        case "setTenantIdAdmin":
            $out = tenantIdAdminCheck($inputData);
            break;
        case "clearTenantId":
            $out = clearTenantId($inputData);
            break;
        case "addNewTenantDeliveryRules":
            $inputData['nextOperation'] = 'insertNewTenantDeliveryRule';
            $out = checkTenantExists($inputData);
            break;
        case "updateTenantDeliveryRules":
            $inputData['tableName'] = 'tenantDeliveryRules';
            $inputData['idName'] = 'deliveryRules';
            $inputData['actionType'] = 'update';    
            $out = updateContent($inputData);
            break;
        case "deleteTenantDeliveryRules":
            $inputData['tableName'] = 'tenantDeliveryRules';
            $inputData['idName'] = 'deliveryRules';
            $inputData['actionType'] = 'delete';
            $out = updateContent($inputData);
            break;
        case "viewTenantDeliveryRulesOwner":
            $inputData['view'] = 'owner';
            $inputData['nextOperation'] = 'viewTenantDeliveryRules';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantDeliveryRulesSysAdmin":
            $inputData['view'] = 'sysAdmin';
            $inputData['nextOperation'] = 'viewTenantDeliveryRules';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantDeliveryRulesPublic":
            $inputData['view'] = 'restricted';
            $inputData['nextOperation'] = 'viewTenantDeliveryRules';
            $out = executeDatabaseOperation($inputData);
            break;
        case "insertTenantFees":
            $inputData['nextOperation'] = 'insertNewTenantFees';
            $out = checkTenantExists($inputData);
            break;
        case "updateTenantFees":
            $inputData['tableName'] = 'tenantAdminFees';
            $inputData['idName'] = 'tenantAdminFees';
            $inputData['actionType'] = 'update';
            $out = updateContent($inputData);
            break;
        case "deleteTenantFees":
            $inputData['tableName'] = 'tenantAdminFees';
            $inputData['idName'] = 'tenantAdminFees';
            $inputData['actionType'] = 'delete';
            $out = updateContent($inputData);
            break;
        default:
            $out['status']   = 'failed';
            $out['message']  = 'No Action Found';
            break;
    }
}else{
    $out = $security;
    if($security['security'] === '0'){
        unset($out['security']);
    }

}

if(defined('TEST_ENV')){
//    $out['testInfo']['1'] = $testInfo;
//    $out['testInfo']['2'] = $_GET;
//    $out['testInfo']['3'] = $_POST;
//      $out['inputData']     = $inputData;
      $out['security']      = $security;
      $out['action']        = $action;
}

echo json_encode(propagateStatusAndMessage($out));
?>
