-- Cascading delete script for tenant cleanup
-- This script deletes all records related to a specific tenant
-- Working from dependent tables to the main tenant table to maintain referential integrity
-- 
-- Usage: Replace @tenant_id with the actual tenant ID to delete
-- Example: SET @tenant_id = 123;

SET @tenant_id = :tenant_id; -- Replace with actual tenant ID

-- Step 1: Delete from dependent tables first (leaf tables)
-- tenant_history (no foreign key dependencies, but references tenant)
DELETE FROM tenant_history 
WHERE tenant_id = @tenant_id;

-- Step 2: Delete business hours
DELETE FROM tenant_business_hours 
WHERE tenant_id = @tenant_id;

-- Step 3: Delete delivery rules
DELETE FROM tenant_delivery_rules 
WHERE tenant_id = @tenant_id;

-- Step 4: Delete admin fees
DELETE FROM tenant_admin_fees 
WHERE tenant_id = @tenant_id;

-- Step 5: Delete themes
DELETE FROM tenant_theme 
WHERE tenant_id = @tenant_id;

-- Step 6: Delete contact information
DELETE FROM tenant_contact 
WHERE tenant_id = @tenant_id;

-- Step 7: Handle hierarchical tenant structure
-- First delete child tenants (tenants that have this tenant as parent)
-- Note: This will recursively delete all descendants if they exist
DELETE FROM tenant 
WHERE parent_id = @tenant_id;

-- Step 8: Finally delete the main tenant record
DELETE FROM tenant 
WHERE id = @tenant_id;

-- Verification queries (optional - uncomment to verify deletion)
/*
SELECT 'Main tenant remaining' as check_type, COUNT(*) as count 
FROM tenant WHERE id = @tenant_id
UNION ALL
SELECT 'Child tenants remaining' as check_type, COUNT(*) as count 
FROM tenant WHERE parent_id = @tenant_id
UNION ALL
SELECT 'Contact records remaining' as check_type, COUNT(*) as count 
FROM tenant_contact WHERE tenant_id = @tenant_id
UNION ALL
SELECT 'Theme records remaining' as check_type, COUNT(*) as count 
FROM tenant_theme WHERE tenant_id = @tenant_id
UNION ALL
SELECT 'Business hours remaining' as check_type, COUNT(*) as count 
FROM tenant_business_hours WHERE tenant_id = @tenant_id
UNION ALL
SELECT 'Delivery rules remaining' as check_type, COUNT(*) as count 
FROM tenant_delivery_rules WHERE tenant_id = @tenant_id
UNION ALL
SELECT 'Admin fees remaining' as check_type, COUNT(*) as count 
FROM tenant_admin_fees WHERE tenant_id = @tenant_id
UNION ALL
SELECT 'History records remaining' as check_type, COUNT(*) as count 
FROM tenant_history WHERE tenant_id = @tenant_id;
*/