<?php

    function idList(){
        $idList = ['tenant' => 'tenantId', 'tenantTheme' => 'themeId', 'tenantContact' => 'contactId', 'tenantBusinessHours' => 'businessHoursId', 
                   'tenantAdminFees' => 'adminFeesId', 'tenantDeliveryRules' => 'deliveryRuleId'];
        return $idList;
    }
    function tableColumnMapping(){
        $tablesColumn = [
            'tenant' => [
                'companyName'           => ['mapping' => 'company_name',            'updateRole' => [1,3],      'optional' => 0],
                'domain'                => ['mapping' => 'domain',                  'updateRole' => [1,3],      'optional' => 0],
                'companyNumber'         => ['mapping' => 'company_number',          'updateRole' => [1,3],      'optional' => 0],
                'foodHygieneId'         => ['mapping' => 'food_hygiene_id',         'updateRole' => [1,3],      'optional' => 1],
                'primaryContactName'    => ['mapping' => 'primary_contact_name',    'updateRole' => [1,3],      'optional' => 0],
                'tenantStatus'          => ['mapping' => 'tenant_status',           'updateRole' => [1,3],      'optional' => 0],
                'isDeleted'             => ['mapping' => 'is_deleted',              'updateRole' => [1],        'optional' => 0],
                'parentId'              => ['mapping' => 'parent_id',               'updateRole' => [1,3],      'optional' => 0],
                'paymentProvider'       => ['mapping' => 'payment_provider',        'updateRole' => [1,3],      'optional' => 1],
                'paymentApiKey'         => ['mapping' => 'payment_api_key',         'updateRole' => [1,3],      'optional' => 1],
                'minimumOrderAmount'    => ['mapping' => 'minimum_order_amount',    'updateRole' => [1,3,4,5],  'optional' => 1],
                'smallOrderFee'         => ['mapping' => 'small_order_fee',         'updateRole' => [1,3,4,5],  'optional' => 1],
                'maxDistance'           => ['mapping' => 'max_distance',            'updateRole' => [1,3,4,5],  'optional' => 1],
                'activeDelivery'        => ['mapping' => 'active_delivery',         'updateRole' => [1,3,4,5],  'optional' => 1],
                'activePickup'          => ['mapping' => 'active_pickup',           'updateRole' => [1,3,4,5],  'optional' => 1],
            ],
            'tenantTheme' => [
                'themeName'             => ['mapping' => 'theme_name',              'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'primaryColor'          => ['mapping' => 'primary_color',           'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'secondaryColor'        => ['mapping' => 'secondary_color',         'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'textColor'             => ['mapping' => 'text_color',              'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'secondaryTextColor'    => ['mapping' => 'secondary_text_color',    'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'accentColor'           => ['mapping' => 'accent_color',            'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'backgroundColor'       => ['mapping' => 'background_color',        'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'buttonColor'           => ['mapping' => 'button_color',            'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'themeStatus'           => ['mapping' => 'theme_status',            'updateRole' => [1,2,3,4,5],  'optional' => 1],
                'isApplied'             => ['mapping' => 'is_applied',              'updateRole' => [1,2,3,4,5],  'optional' => 1],
                'isDeleted'             => ['mapping' => 'is_deleted',              'updateRole' => [1,2,3,4],    'optional' => 1],
            ],
            'tenantContact' => [
                'contactType'           => ['mapping' => 'contact_type',            'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'isPrimary'             => ['mapping' => 'is_primary',              'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'label'                 => ['mapping' => 'label',                   'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'contactValue'          => ['mapping' => 'contact_value',           'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'userId'                => ['mapping' => 'user_id',                 'updateRole' => [1,2,3],      'optional' => 1],
                'isDeleted'             => ['mapping' => 'is_deleted',              'updateRole' => [1,2,3,4,5],  'optional' => 1],
            ],
            'tenantBusinessHours' => [
                'hoursCategory'         => ['mapping' => 'hours_category',          'updateRole' => [1,2,3,4,5],  'optional' => 0],
                'openingDay'            => ['mapping' => 'opening_day',             'updateRole' => [1,2,3,4,5],  'optional' => 1],
                'specificDate'          => ['mapping' => 'specific_date',           'updateRole' => [1,2,3,4,5],  'optional' => 1],
                'openTime'              => ['mapping' => 'open_time',               'updateRole' => [1,2,3,4,5],  'optional' => 1],
                'closeTime'             => ['mapping' => 'close_time',              'updateRole' => [1,2,3,4,5],  'optional' => 1],
                'isClosed'              => ['mapping' => 'is_closed',               'updateRole' => [1,2,3,4,5],  'optional' => 1],
                'isDeleted'             => ['mapping' => 'is_deleted',              'updateRole' => [1,2,3,4],    'optional' => 1],
            ],
            'tenantAdminFees' => [
                'customerAdminFee'      => ['mapping' => 'customer_admin_fee',     'updateRole' => [1,2,3],       'optional' => 0],
                'tenantAdminFee'        => ['mapping' => 'tenant_admin_fee',       'updateRole' => [1,2,3],       'optional' => 0],
                'isActive'              => ['mapping' => 'is_active',              'updateRole' => [1,2,3],       'optional' => 1],
                'isDeleted'             => ['mapping' => 'is_deleted',             'updateRole' => [1,2,3],       'optional' => 1],
            ],
            'tenantDeliveryRules' => [
                'minimumDeliveryAmount' => ['mapping' => 'minimum_delivery_amount','updateRole' => [1,2,3,4,5],   'optional' => 0],
                'deliveryCharge'        => ['mapping' => 'delivery_charge',        'updateRole' => [1,2,3,4,5],   'optional' => 0],
                'isActive'              => ['mapping' => 'is_active',              'updateRole' => [1,2,3,4,5],   'optional' => 1],
                'isDeleted'             => ['mapping' => 'is_deleted',             'updateRole' => [1,2,3,4,5],   'optional' => 1],
            ],
        ];
        return $tablesColumn;
    }
    function updateContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $res = "";
        // 00 Check if tableid is present in the input data
        $tableName = $inputData['tableName'];
        $idName = $inputData['idName'];
        if(!isset($inputData[$tableName][$idName.'Id']) || empty($inputData[$tableName][$idName.'Id'])){
            if(!isset($inputData[$idName.'Id']) || empty($inputData[$idName.'Id'])){
                $result['status'] = 'failed';
                $result['message'] = 'Missing '.$idName.'Id';
                return $result;
            }
        }

        // 01 Check for the id field related to the table from the idList function
        $idList = idList();
        $tablesColumn = tableColumnMapping();
        if(array_key_exists($inputData['tableName'], $idList)){
            $inputData['id'] = $inputData[$inputData['tableName']][$idList[$inputData['tableName']]]?? $inputData[$idName.'Id'];
        }
        if(array_key_exists('parentId', $tablesColumn[$tableName])){
            $inputData['checkParent'] = 1;
        }else{
            $inputData['checkParent'] = 0;
        }

        // 02 Check if the id field is present in the input data
        if(!isset($inputData['id']) || empty($inputData['id'])){
            $result['status'] = 'failed';
            $result['message'] = 'Missing '.$inputData['idName'].'Id';
            $result['check'] = 2;
            return $result;
        }
        // 02.1 check if recored is soft deleted
        $inputData['nextOperation'] = 'checkIfAlreadyDeleted';
        $res = executeDatabaseOperation($inputData);
        if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
            $result['output'] = $res;
            $result['message'] = 'No content found for the id '.$inputData['id'];
            $result['status'] = 'failed';
            return $result;
        }


        //03 begin transaction
        $pdo->beginTransaction();
        try {

            // 04 Get history data for the id field related to the table from the idList function
            $inputData['nextOperation'] = 'selectDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
                $result['output'] = $res;
                $result['message'] = 'No content found for the id '.$inputData['id'];
                $result['status'] = 'failed';
                //04.b Rollback transaction
                $pdo->rollback();
                return $result;
            }
            // 04.a check history for children if the tenant is deleted
                // TO BUILD


            $inputData['his'] = $res['his'];
            // 05 insert history data into the history table
            $inputData['nextOperation'] = 'insertHistoryRecord';
            $res = executeDatabaseOperation($inputData);
 
            // 06 check if the action is delete and if so check if not already deleted
            if($inputData['actionType'] == 'delete'){
                $inputData['nextOperation'] = 'checkIfAlreadyDeleted';
                $res = executeDatabaseOperation($inputData);
                if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
                    //04.b Rollback transaction
                    $pdo->rollback();
                    return $res;
                }
            }

            // 07 make chanage that is requierd to be made to the table
            $inputData['nextOperation'] = 'genericUpdateStatment';
            $res = executeDatabaseOperation($inputData);
            if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
                //04.b Rollback transaction
                $pdo->rollback();
                return $res;
            }

            // 08 commit the transaction
            $pdo->commit();
        } catch (Exception $e) {
            // 09 Rollback transaction on error
            $pdo->rollback();
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // 10 Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
            return $results;
        }

        return $out = [
            'status' => 'success',
            'message' => 'Content updated successfully',
            'res' => $res
        ];
    }
    function executeDatabaseOperation( $inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }   
    function checkTenantExists($inputData){
        $tempHold = $inputData['nextOperation'];
        $inputData['nextOperation'] = 'checkIfTenantIdIsValid';
        $res = executeDatabaseOperation($inputData);
        if($res['status'] == 'failed'){
            return $res;
        }
        $inputData['nextOperation'] = $tempHold;
        $out = executeDatabaseOperation($inputData);
        return $out;
    }
    function tenantIdAdminCheck($inputData){
        if(isset($inputData['tenantId'])){
            return ['status' => 'success', 'message' => 'Tenant ID is present'];
        }
        if(isset($inputData['setTenantId'])){
            $_SESSION['tenantId'] = $inputData['setTenantId'];
            return ['status' => 'success', 'message' => 'Tenant ID is present'];
        }
       
        $inputData['nextOperation'] = 'setTenantId';
        $res = executeDatabaseOperation($inputData);
        
        return $res;
    }
    function insertNewTenantWithCheck($inputData) {
        // 1) Check for duplicate domain
        $inputData['nextOperation'] = 'viewTenatDomainCheck';
        $res = executeDatabaseOperation($inputData);
        if (!empty($res['status']) && $res['status'] === 'found') {
            return ['status' => 'failed', 'message' => 'Duplicate Entry: Domain already exists'];
        }

        // 2) Insert new tenant
        $inputData['nextOperation'] = 'insertNewTenant';
        $createdTenant = executeDatabaseOperation($inputData); // <-- keep this separate

        // Build base response
        $final = [
            'newTenant' => $createdTenant
        ];

        // Guard: ensure we actually have a tenantId
        $tenantId = $createdTenant['tenantId'] ?? null;
        $final['tenantId'] = $tenantId;

        // 3) Optionally add tenant to a parent (do NOT overwrite $createdTenant)
        if (($createdTenant['status'] ?? null) === 'success'
            && isset($inputData['tenant']['parentId'])
            && $tenantId !== null) {

            $inputData['tenant']['tenantId'] = $tenantId;
            $inputData['nextOperation'] = 'addTenantToParent';
            $final['parentLink'] = executeDatabaseOperation($inputData);
        }

        // 4) Insert default fees (use the tenantId from the insert result)
        if ($tenantId !== null) {
            $inputData['tenantId'] = $tenantId;

            $inputData['tenantAdminFees']['customerAdminFee'] = 0.50;
            $inputData['tenantAdminFees']['tenantAdminFee']   = 0.50;
            $inputData['tenantAdminFees']['isActive']         = 1;

            $inputData['nextOperation'] = 'insertNewTenantFees';
            $final['fees'] = executeDatabaseOperation($inputData);
        } else {
            // no tenantId present — surface an error to help debugging
            $final['fees'] = [
                'status'  => 'failed',
                'message' => 'tenantId missing; cannot insert default fees'
            ];
        }

        // Optional: top-level status/message mirroring the insert
        $final['status']  = $createdTenant['status']  ?? 'unknown';
        $final['message'] = $createdTenant['message'] ?? null;

        return $final;
    }
    function clearTenantId($inputData){
        if(isset($inputData['tenantId'])){
            unset($_SESSION['tenantId']);
            return ['status' => 'success', 'message' => 'Tenant ID is cleared'];
        }
        return ['status' => 'failed', 'message' => 'Tenant ID is not set'];
    }
?>