-- Recommended default charset/collation at DB or table level
-- CREATE DATABASE yourdb DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Create brands table
drop table if exists wood_brands;
CREATE TABLE `wood_brands` (
  `id`                INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `brand_name`        VARCHAR(255) NOT NULL,
  `brand_img`         VARCHAR(255) NULL,
  `brand_folder`      VARCHAR(20)  NOT NULL,
  `enable`            TINYINT(1)   NOT NULL DEFAULT 1,
  `deleted`           TINYINT(1)   NOT NULL DEFAULT 0,
  `order`             INT NULL,
  `view_product_info`    VARCHAR(255) NOT NULL DEFAULT '',
  `view_product_details` VARCHAR(255) NOT NULL DEFAULT '',
  `created`           DATETIME DEFAULT CURRENT_TIMESTAMP,
  `last_updated`      DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_brand_folder` (`brand_folder`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Products
drop table if exists wood_product;
CREATE TABLE `wood_product` (
  `id`               INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `brand_id`         INT UNSIGNED DEFAULT NULL,
  `no`               VARCHAR(255) NOT NULL,
  `decor_code`       VARCHAR(255) DEFAULT NULL,
  `decor_name`       VARCHAR(255) DEFAULT NULL,
  `decor_group`      VARCHAR(255) NOT NULL,
  `core`             VARCHAR(255) DEFAULT NULL,
  `is_new`           TINYINT(1) DEFAULT 0,
  `is_not_available` TINYINT(1) DEFAULT 0,
  `deleted`          TINYINT(1) NOT NULL DEFAULT 0,
  `created`          DATETIME DEFAULT CURRENT_TIMESTAMP,
  `last_updated`     DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_brand_id` (`brand_id`),
  CONSTRAINT `fk_product_brand`
    FOREIGN KEY (`brand_id`) REFERENCES `wood_brands` (`id`)
      ON UPDATE CASCADE ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Dimensions
drop table if exists wood_product_dimensions;
CREATE TABLE `wood_product_dimensions` (
  `id`           INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id`   INT UNSIGNED NOT NULL,
  `width`        INT,
  `length`       INT,
  `deleted`      TINYINT(1) DEFAULT 0,
  `last_updated` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_dimensions_product_id` (`product_id`),
  CONSTRAINT `fk_dimensions_product`
    FOREIGN KEY (`product_id`) REFERENCES `wood_product` (`id`)
      ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Edge Banding
drop table if exists wood_edge_banding;
CREATE TABLE `wood_edge_banding` (
  `id`              INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `brand_id`        INT UNSIGNED,
  `board_thickness` INT NOT NULL,
  `edge_thickness`  VARCHAR(25) NOT NULL,
  `banding_details` VARCHAR(255) NOT NULL,
  `banding_type`    VARCHAR(255) NOT NULL,
  `deleted`         TINYINT(1) DEFAULT 0,
  `last_updated`    DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_eb_brand_id` (`brand_id`),
  CONSTRAINT `fk_eb_brand`
    FOREIGN KEY (`brand_id`) REFERENCES `wood_brands` (`id`)
      ON UPDATE CASCADE ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Edge Thickness Prices
drop table if exists wood_edge_thicknesses_prices;
CREATE TABLE `wood_edge_thicknesses_prices` (
  `id`               INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `edge_banding_id`  INT UNSIGNED NOT NULL,
  `thickness_range`  VARCHAR(255) NOT NULL,
  `price_per_meter`  DECIMAL(7,2) NOT NULL,   -- widen a bit if needed
  `last_updated`     DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_etp_eb_id` (`edge_banding_id`),
  CONSTRAINT `fk_etp_eb`
    FOREIGN KEY (`edge_banding_id`) REFERENCES `wood_edge_banding` (`id`)
      ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Product history
drop table if exists wood_product_history;
CREATE TABLE `wood_product_history` (
  `history_id`       INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id`       INT UNSIGNED,
  `brand_id`         INT UNSIGNED,
  `user_id`          INT,
  `no`               VARCHAR(255),
  `decore_code`      VARCHAR(255),   -- NOTE: spelling differs from "decor_code"
  `decore_group`     VARCHAR(255),
  `decore_name`      VARCHAR(255),
  `core`             VARCHAR(255),
  `is_new`           TINYINT(1) DEFAULT 0,
  `is_not_available` TINYINT(1) DEFAULT 1,
  `dimensions_price` LONGTEXT,
  `images`           LONGTEXT,
  `deleted`          TINYINT(1) DEFAULT 0,
  `change_type`      ENUM('INSERT','UPDATE','DELETE'),
  `change_timestamp` DATETIME DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`history_id`),
  KEY `idx_hist_product` (`product_id`),
  KEY `idx_hist_brand` (`brand_id`),
  CONSTRAINT `fk_hist_product`
    FOREIGN KEY (`product_id`) REFERENCES `wood_product` (`id`)
      ON UPDATE CASCADE ON DELETE SET NULL,
  CONSTRAINT `fk_hist_brand`
    FOREIGN KEY (`brand_id`) REFERENCES `wood_brands` (`id`)
      ON UPDATE CASCADE ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Pricing per dimension
drop table if exists wood_product_pricing;
CREATE TABLE `wood_product_pricing` (
  `id`            INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `dimensions_id` INT UNSIGNED,
  `thickness`     DECIMAL(5,2),
  `price`         DECIMAL(10,2),
  `deleted`       TINYINT(1) DEFAULT 0,
  `last_updated`  DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_pricing_dimensions_id` (`dimensions_id`),
  CONSTRAINT `fk_pricing_dimensions`
    FOREIGN KEY (`dimensions_id`) REFERENCES `wood_product_dimensions` (`id`)
      ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Images
drop table if exists wood_product_images;
CREATE TABLE `wood_product_images` (
  `id`            INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id`    INT UNSIGNED,
  `no`            VARCHAR(255),  -- keep consistent with product.no type
  `image_path`    VARCHAR(255),
  `image_location` VARCHAR(255),
  `deleted`       TINYINT(1) DEFAULT 0,
  `last_updated`  DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_images_product_id` (`product_id`),
  CONSTRAINT `fk_images_product`
    FOREIGN KEY (`product_id`) REFERENCES `wood_product` (`id`)
      ON UPDATE CASCADE ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
