-- Create brands table
CREATE TABLE `wood_brands` (
  id int(11)        NOT NULL,
  brand_name        varchar(255) NOT NULL,
  brand_img         varchar(255) DEFAULT NULL,
  brand_folder      varchar(20) NOT NULL,
  `enable`          int(11) NOT NULL DEFAULT 1,
  view_product_info int(11) NOT NULL DEFAULT 0,
  created           datetime DEFAULT current_timestamp(),
  deleted           int(11) NOT NULL,
  order             int(11) DEFAULT NULL,
  view_product_details int(11) DEFAULT 0,
  last_updated       datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB

CREATE TABLE `wood_product` (
  id                        int(11) NOT NULL,
  brand_id                  int(11) DEFAULT NULL,
  `no`                      varchar(255) NOT NULL,
  decor                     varchar(255) DEFAULT NULL,
  decor_code                varchar(255) DEFAULT NULL,
  decor_name                varchar(255) DEFAULT NULL,
  decor_group               varchar(255) NOT NULL,
  core                      varchar(255) DEFAULT NULL,
  `length`                  int(11) DEFAULT NULL,
  width                     int(11) DEFAULT NULL,
  image_path                varchar(255) DEFAULT NULL,
  image_path_2              varchar(255) DEFAULT NULL,
  image_location            varchar(255) NOT NULL,
  is_new                    tinyint(1) DEFAULT 0,
  is_not_available          tinyint(1) DEFAULT 0,
  deleted                   int(11) NOT NULL DEFAULT 0,
  created                   datetime DEFAULT current_timestamp(),
  last_updated              datetime DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE wood_product_dimensions (
    id                      INT AUTO_INCREMENT PRIMARY KEY,
    product_id              INT,
    old_product_id          int(11) DEFAULT NULL,
    width                   INT,
    'length'                INT,
    deleted                 INT DEFAULT 0,
    last_updated            DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (product_id) REFERENCES wood_product(id)
) ENGINE=InnoDB;



-- Edge Banding Prices table
CREATE TABLE wood_edge_banding (
    id INT AUTO_INCREMENT PRIMARY KEY,
    board_thickness int NOT NULL,
    banding_details VARCHAR(255) NOT NULL,
    edge_thickness VARCHAR(25) NOT NULL,
    banding_type VARCHAR(255) NOT NULL,
    deleted int DEFAULT 0,
    brand_id INT,
    last_updated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (brand_id) REFERENCES wood_brands(id)
)ENGINE=InnoDB;

-- Board Thicknesses table
CREATE TABLE wood_edge_thicknesses_prices (
    id INT AUTO_INCREMENT PRIMARY KEY,
    edge_banding_id INT NOT NULL,
    thickness_range VARCHAR(255) NOT NULL,
    price_per_meter DECIMAL(5, 2) NOT NULL,
    last_updated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (edge_banding_id) REFERENCES wood_edge_banding(id)
)ENGINE=InnoDB;



-- Create product_history table
CREATE TABLE wood_product_history (
    history_id INT AUTO_INCREMENT PRIMARY KEY,
    product_id INT,
    brand_id INT,
    no VARCHAR(255),
    decore_code VARCHAR(255),
    decore_group VARCHAR(255),
    decore_name VARCHAR(255),
    core VARCHAR(255),
    length VARCHAR(255),
    width VARCHAR(255),
    is_new TINYINT(1) DEFAULT 0,
    is_not_available TINYINT(1) DEFAULT 1,
    image_path VARCHAR(255),
    image_path_2 VARCHAR(255),
    thickness DECIMAL(5, 2) null,
    price DECIMAL(10, 2) null,
    image_location VARCHAR(255),
    deleted int DEFAULT 0,
    change_type ENUM('INSERT', 'UPDATE', 'DELETE'),
    change_timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (product_id) REFERENCES wood_product(id),
    FOREIGN KEY (brand_id) REFERENCES wood_brands(id)
) ENGINE=InnoDB;


CREATE TABLE wood_product_pricing (
    id              INT AUTO_INCREMENT PRIMARY KEY,
    product_id      INT,
    dimensions_id   INT(11) DEFAULT NULL,
    thickness       DECIMAL(5,2),
    price           DECIMAL(10,2),
    deleted         INT DEFAULT 0,
    last_updated    DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (product_id) REFERENCES wood_product(id)
) ENGINE=InnoDB;


CREATE TABLE wood_product_images (
    id              int primary key auto_increment,
    product_id      int,
    `no`              int,
    image_path      varchar(255),
    image_location  varchar(255),
    deleted         INT DEFAULT 0,
    last_updated    DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (product_id) REFERENCES wood_product(id)
)ENGINE=InnoDB;