<?php

    function createBrand($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $query = "SELECT COALESCE(MAX(`order`), 0) + 1 AS next_order FROM wood_brands";
        $stmt = $pdo->prepare($query);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $nextOrder = $row['next_order'];
        if(!isset($inputData['viewProductDetails'])){
            $inputData['viewProductDetails'] = 0;
        }

        $sql = ("INSERT INTO wood_brands (brand_name,    brand_img,   brand_folder,   `order`,    `view_product_info`,  `view_product_details`,  `enable` ) 
                 VALUES             (:brand_name,   :brand_img, :brand_folder,    :order,     :view_product_info,  :view_product_details,   0        );");
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':brand_name', $inputData['brandName']);
        $stmt->bindParam(':brand_img', $inputData['brandImg']);
        $stmt->bindParam(':brand_folder', $inputData['brandName']);
        $stmt->bindParam(':order', $nextOrder);
        $stmt->bindParam(':view_product_info', $inputData['viewProductInfo']);
        $stmt->bindParam(':view_product_details', $inputData['viewProductDetails']);
        $stmt->execute();
        if ($stmt->rowCount() > 0) { 
            $data['status'] = 'success';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No content found';
        }
        return $data;
    }

    function newProduct($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];

        $query = "SELECT COALESCE(MAX(`no`), 0) + 1 AS next_no FROM wood_product WHERE brand_id = :brand_id";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':brand_id', $inputData['brandId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $nextNo = $row['next_no'];

        $sql = ("INSERT INTO wood_product ( brand_id, no, decor_code, decor_name, decor_group, core) 
                    VALUES (:brand_id, :no, :decore_code, :decore_name, :decore_group, :core);");
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':brand_id', $inputData['brandId']);
        $stmt->bindParam(':no', $nextNo);
        $stmt->bindParam(':decore_code', $inputData['decoreCode']);
        $stmt->bindParam(':decore_name', $inputData['decoreName']);
        $stmt->bindParam(':decore_group', $inputData['decoreGroup']);
        $stmt->bindParam(':core', $inputData['core']);
        $stmt->execute();
        // get the last inserted id
        if ($stmt->rowCount() > 0) { 
            $data['status'] = 'success';
            $lastId = $pdo->lastInsertId();
            $inputData['productId'] = $lastId; ;
            $data['productId'] = $lastId;
            $data['productDimensions'] = insertDimensions($inputData);
            $data['productImages'] = insertImage($inputData);
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'New product failed to be added';
        }
        return $data;
    }

    function insertDimensions($inputData){
         // Validate input data structure
         if (empty($inputData['dimensions']) || !is_array($inputData['dimensions'])) {
            $data['message'] = 'Invalid or missing price data.';
        }
        $pdo = $inputData['db']['dbApp'];
        $sql = "INSERT INTO wood_product_dimensions (product_id, `length`, width) VALUES (:product_id, :length, :width)";
        $stmt = $pdo->prepare($sql);
        $data = [];
        foreach ($inputData['dimensions'] as $dimensions) {
            if (!isset($dimensions['length'], $dimensions['width'])) {
                throw new InvalidArgumentException('Missing length or width in dimensions item.');
            }
            // Bind parameters and execute the statement
            $stmt->bindValue(':product_id', $inputData['productId'], PDO::PARAM_INT);
            $stmt->bindValue(':length', $dimensions['length']);
            $stmt->bindValue(':width', $dimensions['width'], PDO::PARAM_STR);

            try {
                $stmt->execute();
                // Optionally collect inserted IDs or status
                $result['id'] = $pdo->lastInsertId();
                $inputData['dimensionsId'] = $pdo->lastInsertId();
                $inputData['price'] = $dimensions['price'];
                $result['productPrice'] = insertPricedimensions($inputData);
                $data[] = $result;
            } catch (PDOException $e) {
                // Log the error and decide whether to continue or halt
                throw $e; // Or handle gracefully
            }
        }
        return $data; // Return IDs of inserted rows or any meaningful data
    }

    function insertPriceDimensions($inputData){
         // Validate input data structure
         if (empty($inputData['price']) || !is_array($inputData['price'])) {
            $data['message'] = 'Invalid or missing price data.';
        }
        $pdo = $inputData['db']['dbApp'];
        $sql = "INSERT INTO wood_product_pricing (dimensions_id, thickness, price) VALUES (:dimensions_id, :thickness, :price)";
        $stmt = $pdo->prepare($sql);
        $data = [];
        foreach ($inputData['price'] as $priceItem) {
            if (!isset($priceItem['thickness'], $priceItem['price'])) {
                throw new InvalidArgumentException('Missing thickness or price in price item.');
            }
            // Bind parameters and execute the statement
            $stmt->bindValue(':thickness',      $priceItem['thickness']);
            $stmt->bindValue(':price',          $priceItem['price'], PDO::PARAM_STR);
            $stmt->bindValue(':dimensions_id',  $inputData['dimensionsId'], PDO::PARAM_INT);
            try {
                $stmt->execute();
                // Optionally collect inserted IDs or status
                $data[] = $pdo->lastInsertId();
            } catch (PDOException $e) {
                // Log the error and decide whether to continue or halt
                throw $e; // Or handle gracefully
            }
        }
        return $data; // Return IDs of inserted rows or any meaningful data
    }

    function insertImage($inputData){
        if (empty($inputData['images']) || !is_array($inputData['images'])) {
            $data['message'] = 'Invalid or missing price data.';
        }
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $query = "SELECT COALESCE(MAX(`no`), 0) + 1 AS next_no FROM wood_product_images WHERE product_id = :product_id";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':product_id', $inputData['productId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $nextNo = $row['next_no'];
        $sql = "INSERT INTO wood_product_images (product_id, `no`, image_path, image_location) VALUES (:product_id, :no, :image_path, :image_location)";
        $stmt = $pdo->prepare($sql);
        $data = [];
        foreach ($inputData['images'] as $images) {
            if (!isset($images['imagePath'], $images['imageLocation'])) {
                $data['message'] =('Missing imagePath or imageLocation in dimensions item.');
                $data['status'] = 'failed';
            }
            // Bind parameters and execute the statement
            $stmt->bindValue(':product_id', $inputData['productId'], PDO::PARAM_INT);
            $stmt->bindValue(':no', $nextNo);
            $stmt->bindValue(':image_path', $images['imagePath']);
            $stmt->bindValue(':image_location', $images['imageLocation'], PDO::PARAM_STR);

            try {
                $stmt->execute();
                // Optionally collect inserted IDs or status
                $result['id'] = $pdo->lastInsertId();
                $data[] = $result;
            } catch (PDOException $e) {
                 // Log the error and decide whether to continue or halt
                throw $e; // Or handle gracefully

            }
        }
        return $data; // Return IDs of inserted rows or any meaningful data
    }

    function insertChangeRecord($inputData){
        $data       = [];
        $deleted    = 0;
        if($inputData['getOldContent']['thickness'] == "" || $inputData['getOldContent']['thickness'] == null || !isset($inputData['getOldContent']['thickness'])){
            $inputData['getOldContent']['thickness'] = json_encode($inputData['pricing']['thickness']);
        }

        if($inputData['getOldContent']['price'] == "" || $inputData['getOldContent']['price'] == null || !isset($inputData['getOldContent']['price'])){
            $inputData['getOldContent']['price'] = json_encode($inputData['pricing']['price']);
        }

        if($inputData['change_type'] == 'DELETE'){
            $deleted = 1;
        }

        // stringafy this array
        $dimensionsString = json_encode($inputData['getOldContent']['dimensions']);
        $imagesString = json_encode($inputData['getOldContent']['images']);
        
        $pdo = $inputData['db']['dbApp'];
        $sql = "Insert into wood_product_history (product_id, brand_id, no, decore_code, decore_group, decore_name, core, is_new, is_not_available, change_type, deleted, dimensions_prices, user_id, images) values (:product_id, :brand_id, :no, :decore_code, :decore_group, :decore_name, :core, :is_new, :is_not_available, :change_type, :deleted, :dimensions_prices, :user_id, :images)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':product_id',        $inputData['productId']);
        $stmt->bindParam(':brand_id',          $inputData['getOldContent']['brandId']);
        $stmt->bindParam(':no',                $inputData['getOldContent']['no']);
        $stmt->bindParam(':decore_code',       $inputData['getOldContent']['decorCode']);
        $stmt->bindParam(':decore_group',      $inputData['getOldContent']['decorGroup']);
        $stmt->bindParam(':decore_name',       $inputData['getOldContent']['decorName']);
        $stmt->bindParam(':core',              $inputData['getOldContent']['core']);
        $stmt->bindParam(':is_new',            $inputData['getOldContent']['isNew']);
        $stmt->bindParam(':is_not_available',  $inputData['getOldContent']['isNotAvailable']);
        $stmt->bindParam(':dimensions_prices', $dimensionsString); // this is an array of objects
        $stmt->bindParam(':images',            $imagesString);
        $stmt->bindParam(':change_type',       $inputData['change_type']);
        $stmt->bindParam(':deleted',           $deleted);
        $stmt->bindParam(':user_id',           $inputData['userId']);
        $stmt->execute();
        if ($stmt->rowCount() > 0) { 
            $data['status'] = 'success';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No content found';
        }
        return $data;
    }
?>