<?php

    function newBrand($inputData){
        $data = CheckBrandisNew($inputData);
        if($data['status'] == 'success'){
            $data = createBrand($inputData);
        }
        return $data;
    }
    function viewProductInfoFromBrand($inputData){
        $brandId = $inputData['brandId'] ?? ''; 
        if(empty($brandId)){
            $data['status'] = 'failed';
            $data['message'] = 'No Brand ID Found';
            return $data;
        }
        $data = [];
        if($brandId == '10'){
            $data = edgeBanding($inputData);
        }else{ 
           $data = standardProduct($inputData);
        }
        return $data;  
    }
    function executeDatabaseOperation( $inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();

            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function contentChange($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->beginTransaction();
        try{
            $data = getProductForHistory($inputData);
            if($data['status'] != 'success'){
                $pdo->rollback();
                return $data;
            }
            $inputData['getOldContent'] = $data['cms'];
            $inputData['change_type']   = $inputData['type'];
            $check = insertChangeRecord($inputData);
            if($check['status'] == 'success'){
                $inputData['nextOperation'] = $inputData['followUp'];
                $result['result'] = executeDatabaseOperation($inputData);

                $res = propagateStatusAndMessage($result);

                if($res['status'] == 'success'){
                    $pdo->commit();
                return $result;
                }
            }else{
                $result[] = $check;
                $result['status'] = 'failed';
            }
            $pdo->rollback();
        }catch (Exception $e) {
        // Rollback transaction on error
            $pdo->rollback();
            $result['message'] =  $e;
        }
        return $result;
    }
?>