# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, "SystemAdmin", "Platform"),
(2, "SupportAgent", "Platform"),
(3, "ContentModerator", "Platform"),
(4, "BusinessOwner", "Tenant"),
(5, "BusinessManager", "Tenant"),
(6, "Staff", "Tenant"),
(7, "Operator", "Tenant"),
(8, "Customer", "Public");
```

## API Summary Table

| Action                    | Method | Required Role    | Description                                                                                           |
|---------------------------|--------|------------------|-------------------------------------------------------------------------------------------------------|
| `brandCreate`             | POST   |  1,2,3,4,5       | Create a new brand                                                                                    |
| `productCreate`           | POST   |  1,2,3,4,5       |                                                                                                       |
| `productUpdate`           | GET    |  1,2,3,4,5       |                                                                                                       |
| `brandUpdate`             | POST   |  1,2,3,4,5       |                                                                                                       |
| `brandDelete`             | POST   |  1,2,3,4,5       |                                                                                                       |
| `priceDelete`             | GET    |  1,2,3,4,5       |                                                                                                       |
| `dimensionDelete`         | POST   |  1,2,3,4,5       |                                                                                                       |
| `productDelete`           | POST   |  1,2,3,4,5       |                                                                                                       |
| `productBrandView`        | GET    |  1,2,3,4,5 View  | Logged in will show all data otherwise only enabled, pass last modifed value to check if latest data  |
| `productInfoFromBrand`    | POST   |  1,2,3,4,5       |                                                                                                       |



### `brandCreate`
```json
    "action"                : "brandCreate",
    "brandName"             : "string",
    "brandImg"              : "string" (Path For Azure Image),
    "viewProductInfo"       : "string",
    "viewProductDetails"    : "string"
```

### `productBrandView`
```json
    "action"            :   "productBrandView"
    "lastModified"      :   "dateTime" optional,
```

### `productUpdate`
```json
    "action"            : "productUpdate",
    "id"                :  int,
    "enablebrandName"   : "string"  optional, 
    "brandImg"          : "string"  optional, 
    "brandOrder"        :  int      optional,
    "enable"            :  int      optional,
    "viewProductInfo"   : "string"  optional,
    "viewProductDetails": "string"  optional
```
